require "MF_ISMoodle"
if not MF then return end

local TABAS_DrySelfMenu = {}

TABAS_DrySelfMenu.createMenus = function(player, context, items)
    if #items < 1 then return end

    local playerObj = getSpecificPlayer(player)
    local bathingWet = MF.getMoodle("Wet_Bathing", playerObj:getPlayerNum())
    local towel = nil
    if bathingWet ~= nil and bathingWet:getValue() > 0.5 then
        local item
        local itemType
        for i = 1,#items do
            item = items[i]
            if not instanceof(item, "InventoryItem") then
                item = item.items[1]
            end
            itemType = item:getType()
            if (item:hasTag("Wipeable") or (itemType == "DishCloth" or itemType == "BathTowel")) and instanceof(item, "InventoryItem") then
                towel = item
                if context:getOptionFromName(getText("ContextMenu_Dry_myself")) then
                    context:removeOptionByName(getText("ContextMenu_Dry_myself"))
                end
                break
            end
        end
    end
    if not towel then return end
    
    local option = context:insertOptionAfter(getText("ContextMenu_PlaceItemOnGround"), getText("ContextMenu_Dry_myself"), towel, TABAS_DrySelfMenu.doDrySelf, player)
    local icon = towel:getIcon()
    option.iconTexture = icon
    if towel:hasTag("Wipeable") and towel:getWetness() > 50 then -- for BTO
        option.notAvailable = true
        local tooltip = ISInventoryPaneContextMenu.addToolTip()
        tooltip.description = getText("IGUI_BathTowelsOverhaul_TowelTooWet")
        option.toolTip = tooltip
    end
end

TABAS_DrySelfMenu.onDryMyself = function(towels, player)
    towels = ISInventoryPane.getActualItems(towels)
    for i,k in ipairs(towels) do
        TABAS_DrySelfMenu.doDrySelf(k, player)
        break
    end
end

TABAS_DrySelfMenu.doDrySelf = function(towel, player)
    local playerObj = getSpecificPlayer(player)
    ISInventoryPaneContextMenu.transferIfNeeded(playerObj, towel)

    ISTimedActionQueue.add(TABAS_DrySelf:new(playerObj, towel))
end

Events.OnFillInventoryObjectContextMenu.Add(TABAS_DrySelfMenu.createMenus)

return TABAS_DrySelfMenu